<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Subscription extends Model
{
    protected $table = 'subscriptions';
    protected $primaryKey = 'Subscription_id';
    public $timestamps = true;

    protected $fillable = [
        'Plan_id',
        'Company_id',
        'Name',
        'Start_date',
        'End_date',
        'Status',
        'payment_method', // Added for payment tracking
        'renewal_count', // Added for auto-renewal count
    ];

    protected $casts = [
        'Start_date' => 'datetime',
        'End_date' => 'datetime',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'renewal_count' => 'integer',
    ];

    public function plan(): BelongsTo
    {
        return $this->belongsTo(Plan::class, 'Plan_id', 'Plan_id');
    }

    public function company(): BelongsTo
    {
        return $this->belongsTo(CompanyProfile::class, 'Company_id', 'Company_id');
    }
}
